import java.io.*;
import java.net.*;

public class TcpServer {
    public static void main(String[] args) throws IOException {
        int port = 8080;
        
        try (ServerSocket serverSocket = new ServerSocket(port)) {
            System.out.println("Server listening on port " + port);
            
            try (Socket clientSocket = serverSocket.accept();
                 BufferedReader in = new BufferedReader(
                     new InputStreamReader(clientSocket.getInputStream()));
                 PrintWriter out = new PrintWriter(
                     clientSocket.getOutputStream(), true)) {
                
                System.out.println("Client connected");
                String message = in.readLine();
                System.out.println("Received: " + message);
                out.println("Hello from server");
            }
        }
    }
}

